using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI dialog allowing users to determine a type of blood unit modification to perform
		///</summary>

		#endregion

	public class DlgModifyUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		/// <summary>
		/// List of vbecsUser names to populate cmbModifiedBy
		/// </summary>
		private System.Collections.ArrayList _vbecsUsers;

		/// <summary>
		/// This keeps track of the user's business.
		/// If they do a modification, we set this flag to true, which later
		/// will be used to refresh the modification date with the current time
		/// </summary>
		private bool _startedModification = false;

		#region Form Controls

		private System.Windows.Forms.GroupBox grpModifyOption;
		private System.Windows.Forms.RadioButton rdoThaw;
		private System.Windows.Forms.RadioButton rdoPool;
		private System.Windows.Forms.RadioButton rdoSplit;
		private System.Windows.Forms.RadioButton rdoIrradiate;
		private System.Windows.Forms.RadioButton rdoLeukoreduce;
		private System.Windows.Forms.RadioButton rdoVolumeReduce;
		private System.Windows.Forms.RadioButton rdoWash;
		private System.Windows.Forms.RadioButton rdoRejuvenate;
		private System.Windows.Forms.RadioButton rdoFreeze;
		private System.Windows.Forms.RadioButton rdoDeglycerolize;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpMethod;
		private System.Windows.Forms.RadioButton rdoClosed;
		private System.Windows.Forms.RadioButton rdoOpen;
		private System.Windows.Forms.GroupBox grpDate;
		private System.Windows.Forms.DateTimePicker dtpModificationDate;
		private System.Windows.Forms.Label lblModificationDate;
		private System.Windows.Forms.PictureBox picUnit;
		private System.Windows.Forms.RadioButton rdoSCD;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.RadioButton rdoPoolThawCryo;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.GroupBox grpSplitter;
		private System.Windows.Forms.RadioButton rdoEditPool;
		private System.Windows.Forms.Label lblModifiedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbModifedBy;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgModifyUnit constructor
		/// </summary>
		/// <remarks>Indy</remarks>
		public DlgModifyUnit()
		{		
			//No business rule, but there should be.. Without a localsupplier setup on the division
			//The saves will fail
			BOL.Division divCheck = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);

			if (divCheck.LocalSupplierGuid == System.Guid.Empty)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC026.DivisionNotSetupWithLocalSupplier());
				this.Close();
				return;
			}

			// This call is required by the Windows Form Designer.
			InitializeComponent();			
			SetComponentProperties();
			
			//Fire off the Timer, cuz it's SLLllllllllllllllllllllow
			this.timer1_Tick(this, System.EventArgs.Empty);

			this.CheckValid(this, System.EventArgs.Empty);
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgModifyUnit));
			this.grpModifyOption = new System.Windows.Forms.GroupBox();
			this.rdoEditPool = new System.Windows.Forms.RadioButton();
			this.grpSplitter = new System.Windows.Forms.GroupBox();
			this.rdoPoolThawCryo = new System.Windows.Forms.RadioButton();
			this.rdoDeglycerolize = new System.Windows.Forms.RadioButton();
			this.rdoFreeze = new System.Windows.Forms.RadioButton();
			this.rdoRejuvenate = new System.Windows.Forms.RadioButton();
			this.rdoWash = new System.Windows.Forms.RadioButton();
			this.rdoVolumeReduce = new System.Windows.Forms.RadioButton();
			this.rdoLeukoreduce = new System.Windows.Forms.RadioButton();
			this.rdoIrradiate = new System.Windows.Forms.RadioButton();
			this.rdoSplit = new System.Windows.Forms.RadioButton();
			this.rdoPool = new System.Windows.Forms.RadioButton();
			this.rdoThaw = new System.Windows.Forms.RadioButton();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picUnit = new System.Windows.Forms.PictureBox();
			this.grpMethod = new System.Windows.Forms.GroupBox();
			this.rdoSCD = new System.Windows.Forms.RadioButton();
			this.rdoClosed = new System.Windows.Forms.RadioButton();
			this.rdoOpen = new System.Windows.Forms.RadioButton();
			this.grpDate = new System.Windows.Forms.GroupBox();
			this.cmbModifedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblModifiedBy = new System.Windows.Forms.Label();
			this.dtpModificationDate = new System.Windows.Forms.DateTimePicker();
			this.lblModificationDate = new System.Windows.Forms.Label();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.grpModifyOption.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpMethod.SuspendLayout();
			this.grpDate.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(364, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 443);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpModifyOption
			// 
			this.grpModifyOption.AccessibleDescription = "Select Modification Type";
			this.grpModifyOption.AccessibleName = "Select Modification Type";
			this.grpModifyOption.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpModifyOption.Controls.Add(this.rdoEditPool);
			this.grpModifyOption.Controls.Add(this.grpSplitter);
			this.grpModifyOption.Controls.Add(this.rdoPoolThawCryo);
			this.grpModifyOption.Controls.Add(this.rdoDeglycerolize);
			this.grpModifyOption.Controls.Add(this.rdoFreeze);
			this.grpModifyOption.Controls.Add(this.rdoRejuvenate);
			this.grpModifyOption.Controls.Add(this.rdoWash);
			this.grpModifyOption.Controls.Add(this.rdoVolumeReduce);
			this.grpModifyOption.Controls.Add(this.rdoLeukoreduce);
			this.grpModifyOption.Controls.Add(this.rdoIrradiate);
			this.grpModifyOption.Controls.Add(this.rdoSplit);
			this.grpModifyOption.Controls.Add(this.rdoPool);
			this.grpModifyOption.Controls.Add(this.rdoThaw);
			this.grpModifyOption.Location = new System.Drawing.Point(60, 104);
			this.grpModifyOption.Name = "grpModifyOption";
			this.grpModifyOption.Size = new System.Drawing.Size(274, 216);
			this.grpModifyOption.TabIndex = 1;
			this.grpModifyOption.TabStop = false;
			this.grpModifyOption.Text = "Select Modification Type*";
			// 
			// rdoEditPool
			// 
			this.rdoEditPool.AccessibleDescription = "Add remove units from pool";
			this.rdoEditPool.AccessibleName = "Add remove units from pool";
			this.rdoEditPool.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoEditPool.Location = new System.Drawing.Point(8, 192);
			this.rdoEditPool.Name = "rdoEditPool";
			this.rdoEditPool.Size = new System.Drawing.Size(258, 20);
			this.rdoEditPool.TabIndex = 11;
			this.rdoEditPool.Text = "&Add/Remove Units from Pool";
			this.rdoEditPool.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// grpSplitter
			// 
			this.grpSplitter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSplitter.Location = new System.Drawing.Point(8, 180);
			this.grpSplitter.Name = "grpSplitter";
			this.grpSplitter.Size = new System.Drawing.Size(258, 7);
			this.grpSplitter.TabIndex = 11;
			this.grpSplitter.TabStop = false;
			// 
			// rdoPoolThawCryo
			// 
			this.rdoPoolThawCryo.AccessibleDescription = "Thaw pool cryo";
			this.rdoPoolThawCryo.AccessibleName = "Thaw pool cryo";
			this.rdoPoolThawCryo.Location = new System.Drawing.Point(8, 72);
			this.rdoPoolThawCryo.Name = "rdoPoolThawCryo";
			this.rdoPoolThawCryo.Size = new System.Drawing.Size(128, 24);
			this.rdoPoolThawCryo.TabIndex = 2;
			this.rdoPoolThawCryo.Text = "Thaw/Pool Cr&yo";
			this.rdoPoolThawCryo.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoDeglycerolize
			// 
			this.rdoDeglycerolize.AccessibleDescription = "deglycerolize";
			this.rdoDeglycerolize.AccessibleName = "deglycerolize";
			this.rdoDeglycerolize.Location = new System.Drawing.Point(160, 128);
			this.rdoDeglycerolize.Name = "rdoDeglycerolize";
			this.rdoDeglycerolize.Size = new System.Drawing.Size(112, 24);
			this.rdoDeglycerolize.TabIndex = 10;
			this.rdoDeglycerolize.Text = "De&glycerolize";
			this.rdoDeglycerolize.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoFreeze
			// 
			this.rdoFreeze.AccessibleDescription = "freeze";
			this.rdoFreeze.AccessibleName = "freeze";
			this.rdoFreeze.Location = new System.Drawing.Point(160, 100);
			this.rdoFreeze.Name = "rdoFreeze";
			this.rdoFreeze.Size = new System.Drawing.Size(112, 24);
			this.rdoFreeze.TabIndex = 9;
			this.rdoFreeze.Text = "&Freeze";
			this.rdoFreeze.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoRejuvenate
			// 
			this.rdoRejuvenate.AccessibleDescription = "rejuvenate";
			this.rdoRejuvenate.AccessibleName = "rejuvenate";
			this.rdoRejuvenate.Location = new System.Drawing.Point(160, 72);
			this.rdoRejuvenate.Name = "rdoRejuvenate";
			this.rdoRejuvenate.Size = new System.Drawing.Size(112, 24);
			this.rdoRejuvenate.TabIndex = 8;
			this.rdoRejuvenate.Text = "&Rejuvenate";
			this.rdoRejuvenate.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoWash
			// 
			this.rdoWash.AccessibleDescription = "wash";
			this.rdoWash.AccessibleName = "wash";
			this.rdoWash.Location = new System.Drawing.Point(160, 44);
			this.rdoWash.Name = "rdoWash";
			this.rdoWash.Size = new System.Drawing.Size(112, 24);
			this.rdoWash.TabIndex = 7;
			this.rdoWash.Text = "&Wash";
			this.rdoWash.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoVolumeReduce
			// 
			this.rdoVolumeReduce.AccessibleDescription = "volume reduce";
			this.rdoVolumeReduce.AccessibleName = "volume reduce";
			this.rdoVolumeReduce.Location = new System.Drawing.Point(160, 16);
			this.rdoVolumeReduce.Name = "rdoVolumeReduce";
			this.rdoVolumeReduce.Size = new System.Drawing.Size(112, 24);
			this.rdoVolumeReduce.TabIndex = 6;
			this.rdoVolumeReduce.Text = "&Volume Reduce";
			this.rdoVolumeReduce.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoLeukoreduce
			// 
			this.rdoLeukoreduce.AccessibleDescription = "leukoreduce";
			this.rdoLeukoreduce.AccessibleName = "leukoreduce";
			this.rdoLeukoreduce.Location = new System.Drawing.Point(8, 156);
			this.rdoLeukoreduce.Name = "rdoLeukoreduce";
			this.rdoLeukoreduce.Size = new System.Drawing.Size(128, 24);
			this.rdoLeukoreduce.TabIndex = 5;
			this.rdoLeukoreduce.Text = "&Leukoreduce";
			this.rdoLeukoreduce.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoIrradiate
			// 
			this.rdoIrradiate.AccessibleDescription = "irradiate";
			this.rdoIrradiate.AccessibleName = "irradiate";
			this.rdoIrradiate.Location = new System.Drawing.Point(8, 128);
			this.rdoIrradiate.Name = "rdoIrradiate";
			this.rdoIrradiate.Size = new System.Drawing.Size(128, 24);
			this.rdoIrradiate.TabIndex = 4;
			this.rdoIrradiate.Text = "&Irradiate";
			this.rdoIrradiate.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoSplit
			// 
			this.rdoSplit.AccessibleDescription = "split divide";
			this.rdoSplit.AccessibleName = "split divide";
			this.rdoSplit.Location = new System.Drawing.Point(8, 100);
			this.rdoSplit.Name = "rdoSplit";
			this.rdoSplit.Size = new System.Drawing.Size(128, 24);
			this.rdoSplit.TabIndex = 3;
			this.rdoSplit.Text = "&Split/Divide";
			this.rdoSplit.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoPool
			// 
			this.rdoPool.AccessibleDescription = "pool";
			this.rdoPool.AccessibleName = "pool";
			this.rdoPool.Location = new System.Drawing.Point(8, 44);
			this.rdoPool.Name = "rdoPool";
			this.rdoPool.Size = new System.Drawing.Size(128, 24);
			this.rdoPool.TabIndex = 1;
			this.rdoPool.Text = "&Pool";
			this.rdoPool.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// rdoThaw
			// 
			this.rdoThaw.AccessibleDescription = "Thaw";
			this.rdoThaw.AccessibleName = "Thaw";
			this.rdoThaw.Location = new System.Drawing.Point(8, 16);
			this.rdoThaw.Name = "rdoThaw";
			this.rdoThaw.Size = new System.Drawing.Size(128, 24);
			this.rdoThaw.TabIndex = 0;
			this.rdoThaw.TabStop = true;
			this.rdoThaw.Text = "&Thaw";
			this.rdoThaw.CheckedChanged += new System.EventHandler(this.ModificationTypeChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(182, 423);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(262, 423);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.picUnit);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 381);
			this.grpImage.TabIndex = 44;
			this.grpImage.TabStop = false;
			// 
			// picUnit
			// 
			this.picUnit.Image = ((System.Drawing.Image)(resources.GetObject("picUnit.Image")));
			this.picUnit.Location = new System.Drawing.Point(4, 12);
			this.picUnit.Name = "picUnit";
			this.picUnit.Size = new System.Drawing.Size(45, 45);
			this.picUnit.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picUnit.TabIndex = 38;
			this.picUnit.TabStop = false;
			// 
			// grpMethod
			// 
			this.grpMethod.AccessibleDescription = "method";
			this.grpMethod.AccessibleName = "method";
			this.grpMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMethod.Controls.Add(this.rdoSCD);
			this.grpMethod.Controls.Add(this.rdoClosed);
			this.grpMethod.Controls.Add(this.rdoOpen);
			this.grpMethod.Enabled = false;
			this.grpMethod.Location = new System.Drawing.Point(60, 324);
			this.grpMethod.Name = "grpMethod";
			this.grpMethod.Size = new System.Drawing.Size(274, 92);
			this.grpMethod.TabIndex = 2;
			this.grpMethod.TabStop = false;
			this.grpMethod.Text = "Method*";
			// 
			// rdoSCD
			// 
			this.rdoSCD.AccessibleDescription = "Sterile Connection Device";
			this.rdoSCD.AccessibleName = "Sterile Connection Device";
			this.rdoSCD.Location = new System.Drawing.Point(8, 64);
			this.rdoSCD.Name = "rdoSCD";
			this.rdoSCD.Size = new System.Drawing.Size(160, 20);
			this.rdoSCD.TabIndex = 2;
			this.rdoSCD.TabStop = true;
			this.rdoSCD.Text = "Sterile Co&nnection Device";
			// 
			// rdoClosed
			// 
			this.rdoClosed.AccessibleDescription = "closed";
			this.rdoClosed.AccessibleName = "closed";
			this.rdoClosed.Location = new System.Drawing.Point(8, 40);
			this.rdoClosed.Name = "rdoClosed";
			this.rdoClosed.Size = new System.Drawing.Size(156, 20);
			this.rdoClosed.TabIndex = 1;
			this.rdoClosed.TabStop = true;
			this.rdoClosed.Text = "Close&d";
			// 
			// rdoOpen
			// 
			this.rdoOpen.AccessibleDescription = "open";
			this.rdoOpen.AccessibleName = "open";
			this.rdoOpen.Location = new System.Drawing.Point(8, 16);
			this.rdoOpen.Name = "rdoOpen";
			this.rdoOpen.Size = new System.Drawing.Size(156, 20);
			this.rdoOpen.TabIndex = 0;
			this.rdoOpen.TabStop = true;
			this.rdoOpen.Text = "Op&en";
			// 
			// grpDate
			// 
			this.grpDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDate.Controls.Add(this.cmbModifedBy);
			this.grpDate.Controls.Add(this.lblModifiedBy);
			this.grpDate.Controls.Add(this.dtpModificationDate);
			this.grpDate.Controls.Add(this.lblModificationDate);
			this.grpDate.Location = new System.Drawing.Point(60, 36);
			this.grpDate.Name = "grpDate";
			this.grpDate.Size = new System.Drawing.Size(274, 64);
			this.grpDate.TabIndex = 0;
			this.grpDate.TabStop = false;
			// 
			// cmbModifedBy
			// 
			this.cmbModifedBy.AccessibleDescription = "Modified By";
			this.cmbModifedBy.AccessibleName = "Modified By";
			this.cmbModifedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbModifedBy.Interval = 500;
			this.cmbModifedBy.Location = new System.Drawing.Point(108, 36);
			this.cmbModifedBy.MaxLength = 50;
			this.cmbModifedBy.Name = "cmbModifedBy";
			this.cmbModifedBy.Size = new System.Drawing.Size(142, 22);
			this.cmbModifedBy.TabIndex = 1;
			this.cmbModifedBy.Leave += new System.EventHandler(this.cmbModifedBy_Leave);
			// 
			// lblModifiedBy
			// 
			this.lblModifiedBy.Location = new System.Drawing.Point(8, 36);
			this.lblModifiedBy.Name = "lblModifiedBy";
			this.lblModifiedBy.Size = new System.Drawing.Size(100, 20);
			this.lblModifiedBy.TabIndex = 1;
			this.lblModifiedBy.Text = "Modified By*";
			this.lblModifiedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpModificationDate
			// 
			this.dtpModificationDate.AccessibleDescription = "Modification Date";
			this.dtpModificationDate.AccessibleName = "Modification Date";
			this.dtpModificationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpModificationDate.CustomFormat = "";
			this.dtpModificationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpModificationDate.Location = new System.Drawing.Point(108, 12);
			this.dtpModificationDate.Name = "dtpModificationDate";
			this.dtpModificationDate.Size = new System.Drawing.Size(142, 20);
			this.dtpModificationDate.TabIndex = 0;
			// 
			// lblModificationDate
			// 
			this.lblModificationDate.Location = new System.Drawing.Point(8, 12);
			this.lblModificationDate.Name = "lblModificationDate";
			this.lblModificationDate.Size = new System.Drawing.Size(100, 20);
			this.lblModificationDate.TabIndex = 0;
			this.lblModificationDate.Text = "Modification Date*";
			this.lblModificationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 30000;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// DlgModifyUnit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(364, 459);
			this.Controls.Add(this.grpDate);
			this.Controls.Add(this.grpMethod);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpModifyOption);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimumSize = new System.Drawing.Size(370, 484);
			this.Name = "DlgModifyUnit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Modify Unit(s)";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgModifyUnit_KeyDownSpeakMessage);
			this.Activated += new System.EventHandler(this.DlgModifyUnit_Activated);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.grpModifyOption, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpMethod, 0);
			this.Controls.SetChildIndex(this.grpDate, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpModifyOption.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpMethod.ResumeLayout(false);
			this.grpDate.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Gets product modification type selected
		/// </summary>
		/// <remarks>Indy</remarks>
		private Common.ProductModification ProductModificationCode
		{
			get
			{
				if (this.rdoDeglycerolize.Checked)	return Common.ProductModification.Deglycerolized;
				
				if (this.rdoFreeze.Checked)			return Common.ProductModification.Frozen;
				
				if (this.rdoIrradiate.Checked)		return Common.ProductModification.Irradiated;
				
				if (this.rdoLeukoreduce.Checked)	return Common.ProductModification.LeukoReduced;
				
				if (this.rdoPool.Checked)			return Common.ProductModification.Pooled;
				
				if (this.rdoPoolThawCryo.Checked)	return Common.ProductModification.PoolThawCryo;
				
				if (this.rdoRejuvenate.Checked)		return Common.ProductModification.Rejuvenated;
				
				if (this.rdoSplit.Checked)			return Common.ProductModification.SplitAdult;
				
				if (this.rdoThaw.Checked)			return Common.ProductModification.Thawed;
				
				if (this.rdoVolumeReduce.Checked)	return Common.ProductModification.VolumeReduced;
				
				if (this.rdoWash.Checked)			return Common.ProductModification.Washed;
				
				if (this.rdoEditPool.Checked)		return Common.ProductModification.EditPool;

				return Common.ProductModification.Unknown;
			}
		}

		/// <summary>
		/// Time when the modification took place.  Eventually will become target unit's In-Date(BR_26.22)
		/// </summary>
		/// <remarks>Indy</remarks>
		private System.DateTime ModificationDateTime
		{
			get
			{
				return this.dtpModificationDate.Value.Date.AddHours(this.dtpModificationDate.Value.Hour).AddMinutes(this.dtpModificationDate.Value.Minute).AddSeconds(59);
			}
		}

		/// <summary>
		/// Method of performing the modification.  BR_26.13 - One must be selected.
		/// </summary>
		/// <remarks>Indy</remarks>
		private Common.ModifyUnitMethod ModificationMethod
		{
			get
			{
				if (this.rdoClosed.Checked)	return Common.ModifyUnitMethod.Closed;
				
				if (this.rdoOpen.Checked)	return Common.ModifyUnitMethod.Open;
				
				if (this.rdoSCD.Checked)	return Common.ModifyUnitMethod.SterileConnectingDevice;
				
				//Was Nothing selected?...
				throw new ArgumentException(System.Reflection.MethodBase.GetCurrentMethod().Name);
			}
		}

		/// <summary>
		/// NtLoginID of the User selected in cmbModifiedBy
		/// BR_56.08 - Allows selection of tech id
		/// </summary>
		private string ModificationTechId
		{
			get
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser)this._vbecsUsers[this.cmbModifedBy.SelectedIndex];
				return(vbecsUser.UserNTLoginID);
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Method to initialize UI controls
		/// </summary>
		/// <remarks>Indy</remarks>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Modify Unit(s)";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyUnit());

			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;

			//set custom date and time format
			this.dtpModificationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			
			//set current date value based on the division time zone
			this.dtpModificationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			
			this.EnableModifications();
			this.LoadVbecsUsers();

			this.toolTip1.SetToolTip(this.grpModifyOption, Common.StrRes.Tooltips.UC026.SelectProductModification().ResString);
			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.toolTip1.SetToolTip(this.grpMethod, Common.StrRes.Tooltips.UC026.SelectModificationMethod().ResString);
			this.toolTip1.SetToolTip(this.dtpModificationDate, Common.StrRes.Tooltips.UC026.SelectModificationDate().ResString);
		}

		/// <summary> 
		/// Populates cmbModifiedBy with valid VBECS user names
		/// </summary>
		private void LoadVbecsUsers()
		{
			this.cmbModifedBy.Items.Clear();
			this._vbecsUsers = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );

			//they cannot de-select this so no blank row needed
			for(int ndx=0; ndx < this._vbecsUsers.Count; ndx++)
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser) this._vbecsUsers[ndx];
				cmbModifedBy.Items.Add(vbecsUser.UserName);
			}
			cmbModifedBy.Text = ThisUser.UserName;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Public method to enable and disable product modification selections based on division settings
		/// Follows BR_26.32
		/// </summary>
		/// <remarks>Indy</remarks>
		private void EnableModifications()
		{
			try
			{
				BOL.BloodProductModifications bpm = new BOL.BloodProductModifications(LogonUser.LogonUserDivisionCode);

				System.Collections.Hashtable divParms = bpm.ProductModifications;
				
				this.rdoSplit.Enabled			= bpm.GetModificationStatus(Common.ProductModification.SplitAdult);
				this.rdoFreeze.Enabled			= bpm.GetModificationStatus(Common.ProductModification.Frozen);
				this.rdoDeglycerolize.Enabled	= bpm.GetModificationStatus(Common.ProductModification.Deglycerolized);
				this.rdoIrradiate.Enabled		= bpm.GetModificationStatus(Common.ProductModification.Irradiated);
				this.rdoLeukoreduce.Enabled		= bpm.GetModificationStatus(Common.ProductModification.LeukoReduced);
				this.rdoPool.Enabled			= bpm.GetModificationStatus(Common.ProductModification.Pooled);
				
				this.rdoEditPool.Enabled		= (bpm.GetModificationStatus(Common.ProductModification.Pooled) & IsCurrentUserAuthorizedForFunction( FunctionCode.EditVerifiedUnitConfirmationTesting ));

				this.rdoRejuvenate.Enabled		= bpm.GetModificationStatus(Common.ProductModification.Rejuvenated);
				this.rdoThaw.Enabled			= bpm.GetModificationStatus(Common.ProductModification.Thawed);
				this.rdoPoolThawCryo.Enabled	= bpm.GetModificationStatus(Common.ProductModification.PoolThawCryo);
				this.rdoVolumeReduce.Enabled	= bpm.GetModificationStatus(Common.ProductModification.VolumeReduced);
				this.rdoWash.Enabled			= bpm.GetModificationStatus(Common.ProductModification.Washed);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.GeneralError(err.Message));
				this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
				this.Close();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to enable or disable OK button based on user selections
		/// </summary>
		/// <remarks>Indy</remarks>
		private void CheckValid(object sender, System.EventArgs e)
		{
			string msg = string.Empty;
			string msg1 = string.Empty;
			string msg2 = string.Empty;
			
			if (this.cmbModifedBy.SelectedIndex == -1)
			{
				msg1 = "A Modified Tech name is required.";
			}

			if (this.ProductModificationCode == Common.ProductModification.Unknown)
			{
				msg2 = Common.StrRes.Tooltips.UC026.ProductModificationRequired().ResString;
			}


			if (msg1 == string.Empty && msg2 == string.Empty)
			{
				msg = Common.StrRes.Tooltips.Common.OKToContinue().ResString;
				btnOK.EnabledButton = true;
			}
			else
			{
				msg = Common.Utility.SumBrokenRulesMessages(msg1, msg2);
				btnOK.EnabledButton = false;
			}


			btnOK.SetToolTip(msg);
		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event, loads appropriate unit selection dialog and modification processing form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{

				//Validate the user access
				if (!IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
					return;
				}

				this._startedModification = true;

				//What kind of modification are we performing on the bloodunit?
				switch (this.ProductModificationCode)
				{
						//*****************************************************************************
						//*             POOLING
						//*****************************************************************************
					case Common.ProductModification.Pooled:
					case Common.ProductModification.PoolThawCryo:

						BOL.BloodUnitModification poolControl = new BOL.BloodUnitModification(this.ProductModificationCode, this.ModificationMethod, this.ModificationDateTime, this.ModificationTechId);

						DlgSelectMultipleUnits dlgPoolSelect = new DlgSelectMultipleUnits(poolControl);
				
						if (dlgPoolSelect.ShowDialog(this) == DialogResult.OK)
						{	
							//Moved to Constructor to accomodate the PoolId calculations -- Needs FormInstanceGuid
							//poolControl.PoolUnits(Common.UpdateFunction.UC024FrmPoolUnits);
						
							FrmPoolUnits _frmP = new FrmPoolUnits(poolControl);
							if (_frmP.DialogResult != DialogResult.Abort)
							{
								_frmP.MdiParent = this.MdiParent;
								_frmP.Show();
							}
							else
								_frmP.Dispose();
						}
						break;

						//*****************************************************************************
						//*             EDITING A POOL
						//*****************************************************************************
					case Common.ProductModification.EditPool:
					
						//Method is insignificant.. It adopts from existing pool
						BOL.BloodUnitModification editPoolControl = new BOL.BloodUnitModification(this.ProductModificationCode, Common.ModifyUnitMethod.Open, this.ModificationDateTime, this.ModificationTechId);

						//First the user needs to pick a already-pooled-unit
						DlgSelectSingleUnit dlgSelectPool = new DlgSelectSingleUnit(editPoolControl);

						if (dlgSelectPool.ShowDialog(this) == DialogResult.OK)
						{
							DlgEditPool dlgEditPoolSelect = new DlgEditPool(editPoolControl, dlgSelectPool.BloodUnit);

							if (dlgEditPoolSelect.ShowDialog(this) == DialogResult.OK)
							{	
								//Moved to Constructor to accomodate the PoolId calculations (Consistancy) -- Needs FormInstanceGuid
								FrmPoolUnits _frmP = new FrmPoolUnits(dlgEditPoolSelect.PoolControl);
								if (_frmP.DialogResult != DialogResult.Abort)
								{
									_frmP.MdiParent = this.MdiParent;
									_frmP.Show();
								}
								else
									_frmP.Dispose();
							}
							break;
						}
						break;

						//*****************************************************************************
						//*             SPLITTING
						//*****************************************************************************
					case Common.ProductModification.SplitAdult:

						BOL.BloodUnitModification splitControl = new BOL.BloodUnitModification(this.ProductModificationCode, this.ModificationMethod, this.ModificationDateTime, this.ModificationTechId);

						//BR_25.02 - Split can only process one unit at a time, so DlgSelectSingleUnit()
						DlgSelectSingleUnit dlgSplitSelect = new DlgSelectSingleUnit(splitControl);

						if (dlgSplitSelect.ShowDialog(this) == DialogResult.OK)
						{
							splitControl.SplitUnit(dlgSplitSelect.BloodUnit.BloodUnitGuid, BOL.BloodUnitModification.DefaultSplitUnits);

							//Need to pass the calling form the Guid that actually locked the record --
							//unless I recode to lock the unit in frmSplitUnit???
							FrmSplitUnit _frmS = new FrmSplitUnit(splitControl);
							if (_frmS.DialogResult != DialogResult.Abort)	//Locking will do this
							{
								_frmS.MdiParent = this.MdiParent;
								_frmS.Show(); 
							}
							else
								_frmS.Dispose();
						}

						break;

						//*****************************************************************************
						//*             THAW/IRRADIATE - (BR_26.02 -- can batch multiple units)
						//*****************************************************************************
					case Common.ProductModification.Thawed:
					case Common.ProductModification.Irradiated:

						BOL.BloodUnitModification multipleControl = new BOL.BloodUnitModification(this.ProductModificationCode, this.ModificationMethod, this.ModificationDateTime, this.ModificationTechId);
						DlgSelectMultipleUnits dlgMultiSelect = new DlgSelectMultipleUnits(multipleControl);

						if (dlgMultiSelect.ShowDialog(this) == DialogResult.OK)
						{
							FrmModifyUnits frmMU = new FrmModifyUnits(dlgMultiSelect.BumControlList);
							if (frmMU.DialogResult != DialogResult.Abort)
							{
								frmMU.MdiParent = this.MdiParent;
								frmMU.Show();
							}
							else
								frmMU.Dispose();
						}

						break;

						//*****************************************************************************
						//*             ALL OTHER MODIFICATIONS - (one unit at a time)
						//*****************************************************************************
					default:

						System.Collections.ArrayList oneControlList = new System.Collections.ArrayList();
						BOL.BloodUnitModification modifyControl = new BOL.BloodUnitModification(this.ProductModificationCode, this.ModificationMethod, this.ModificationDateTime, this.ModificationTechId);
						DlgSelectSingleUnit _dlgModifySelect = new DlgSelectSingleUnit(modifyControl);
					
						if (_dlgModifySelect.ShowDialog(this) == DialogResult.OK)
						{
							modifyControl.ModifyUnit(_dlgModifySelect.BloodUnit.BloodUnitGuid);
							oneControlList.Add(modifyControl);

							FrmModifyUnits _frmM = new FrmModifyUnits(oneControlList);
							if (_frmM.DialogResult != DialogResult.Abort)
							{
								_frmM.MdiParent = this.MdiParent;
								_frmM.Show();
							}
							else
								_frmM.Dispose();
						}

						break;
				}

			}
			catch(BOL.BusinessObjectException err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Product modificationn radio buttons check changed event handler, 
		/// enables and disables modification method radio buttons
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void ModificationTypeChanged(object sender, System.EventArgs e)
		{
			this.rdoClosed.Enabled = true;

			//TT26.02 & TT26.03 -- BR_26.10 - disable the option when it's not available
			if (this.rdoThaw.Checked || this.rdoIrradiate.Checked)
			{
				this.rdoClosed.Checked = true;
				this.grpMethod.Enabled = false;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyUnit());
			}
			else if (this.rdoWash.Checked || this.rdoRejuvenate.Checked || this.rdoFreeze.Checked || this.rdoDeglycerolize.Checked)
			{
				this.rdoOpen.Checked = true;
				this.grpMethod.Enabled = false;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyUnit());
			}
			else if (this.rdoPool.Checked || this.rdoPoolThawCryo.Checked)
			{
				this.rdoOpen.Checked = true;
				this.grpMethod.Enabled = true;
				this.rdoClosed.Enabled = false;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgModifyUnit());
			}
			else if (this.rdoSplit.Checked)
			{
				this.rdoOpen.Checked = true;
				this.grpMethod.Enabled = true;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgModifyUnit());
			}
			else if(this.rdoEditPool.Checked)
			{
				this.rdoOpen.Checked = false;
				this.rdoClosed.Checked = false;
				this.rdoSCD.Checked = false;
				this.grpMethod.Enabled = false;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyUnit());
			}
			else
			{
				this.rdoOpen.Checked = true;
				this.grpMethod.Enabled = true;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyUnit());
			}

			this.CheckValid(this, System.EventArgs.Empty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Timer tick event handler, sets maximum selectable modifcation date to current date/time
		/// BR_26.01
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			//On the off-chance that the user is logged in during DaylightSavings time switch,
			//we need to trap for "Fall-back", because the current dtp.Value will be > than the 
			//new DateTime
			System.DateTime tmpDate = BOL.BloodUnitModification.MaximumModificationDateTime;

			if (this.dtpModificationDate.Value > tmpDate)
			{
				this.dtpModificationDate.Value = tmpDate;
			}

			this.dtpModificationDate.MaxDate = tmpDate;
		}

		private void DlgModifyUnit_Activated(object sender, System.EventArgs e)
		{
			//The only way this will get called is after they finish the modification
			if (this._startedModification)
			{
				this.timer1_Tick(this, System.EventArgs.Empty);
				this.dtpModificationDate.Value = this.dtpModificationDate.MaxDate;
				this._startedModification = false;
			}
		}

		private void cmbModifedBy_Leave(object sender, System.EventArgs e)
		{
			this.CheckValid(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgModifyUnit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion
	}
}

